/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.player;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.player.DelayedSoundPlayer;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.sound.player.StepSoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ImmediateSoundPlayer
implements SoundPlayer,
StepSoundPlayer {
    private final Random random = new Random();
    private final DelayedSoundPlayer delayedPlayer = new DelayedSoundPlayer(this);
    private final SoundEngine engine;

    public ImmediateSoundPlayer(SoundEngine engine) {
        this.engine = engine;
    }

    @Override
    public Random getRNG() {
        return this.random;
    }

    @Override
    public void playStep(Association assos) {
        class_2498 soundType = assos.getSoundGroup();
        if (!assos.getMaterial().method_15797() && soundType != null) {
            class_2680 beside = assos.getSource().field_6002.method_8320(assos.getPos().method_10084());
            if (beside.method_26204() == class_2246.field_10477) {
                soundType = class_2246.field_10477.method_9573(beside);
            }
            this.playAttenuatedSound(assos.getSource(), soundType.method_10594().method_14833().toString(), soundType.method_10597() * 0.15f, soundType.method_10599());
        }
    }

    @Override
    public void playSound(class_1309 location, String soundName, float volume, float pitch, Options options) {
        if (options.containsKey("delay_min") && options.containsKey("delay_max")) {
            this.delayedPlayer.playSound(location, soundName, volume, pitch, options);
            return;
        }
        this.playAttenuatedSound(location, soundName, volume, pitch);
    }

    private void playAttenuatedSound(class_1309 location, String soundName, float volume, float pitch) {
        class_310 mc = class_310.method_1551();
        double distance = mc.field_1773.method_19418().method_19326().method_1025(location.method_19538());
        UncappedSoundInstance sound = new UncappedSoundInstance(soundName, volume *= this.engine.getVolumeForSource(location), pitch, (class_1297)location);
        if (distance > 100.0) {
            mc.method_1483().method_4872((class_1113)sound, (int)Math.floor(Math.sqrt(distance) / 2.0));
        } else {
            mc.method_1483().method_4873((class_1113)sound);
        }
    }

    @Override
    public void think() {
        this.delayedPlayer.think();
    }

    public static class UncappedSoundInstance
    extends class_1109 {
        public UncappedSoundInstance(String soundName, float volume, float pitch, class_1297 entity) {
            super(UncappedSoundInstance.getSoundId(soundName, entity), entity.method_5634(), volume, pitch, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5476, entity.method_23317(), entity.method_23318(), entity.method_23321(), false);
        }

        public float getMaxVolume() {
            return 3.0f;
        }

        private static class_2960 getSoundId(String name, class_1297 location) {
            if (name.indexOf(58) >= 0) {
                return new class_2960(name);
            }
            Object domain = "presencefootsteps";
            if (!PlayerUtil.isClientPlayer(location)) {
                domain = (String)domain + "mono";
            }
            return new class_2960((String)domain, name);
        }
    }
}

